/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: PointerFifo_Struct.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    netX Pointer FIFO definitions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-03-24  File created.

**************************************************************************************/


#ifndef _POINTER_FIFO_STRUCT_H
#define _POINTER_FIFO_STRUCT_H


/*************************************************************************************/


/* structure map of netX GPIO registers */

typedef struct NETX_POINTER_FIFO_REGISTERS_Ttag
{
  volatile unsigned long aulData[32];
  volatile unsigned long aulBorder[32];
  volatile unsigned long ulReset;
  volatile unsigned long ulFull;
  volatile unsigned long ulEmpty;
  volatile unsigned long ulOverflow;
  volatile unsigned long ulUnderrun;
  volatile unsigned long aulReserved[27];
  volatile unsigned long aulFillLevel[32];
} NETX_POINTER_FIFO_REGISTERS_T;


typedef struct NETX_POINTER_FIFO_BASE_NO_DATA_Ttag
{
  volatile unsigned long aulBorder[32];
  volatile unsigned long ulReset;
  volatile unsigned long ulFull;
  volatile unsigned long ulEmpty;
  volatile unsigned long ulOverflow;
  volatile unsigned long ulUnderrun;
  volatile unsigned long aulReserved[27];
  volatile unsigned long aulFillLevel[32];
} NETX_POINTER_FIFO_BASE_NO_DATA_T;

#endif
